(*--------------------------------------------------------------------**
**	    	Fa. MAMAvision Software Consult                             **
**		    Wollmatingerstrae 70b  D-78467 Konstanz	                  **
**	      Tel.: (07531)690014     Fax: (07531)690015                  **
**--Projekt-----------------------------------------------------------**
**		                  HPGL-Viewer/Printer                           **
**                     SOFTWARE\HPGL\PAS\....                         **
**--Revisionhistory---------------------------------------------------**
**
lgb
lge
**
**--Module------------------------------------------------------------**
**  Modul-Name      : modname: HPGLDEMO.pas
**  Modul-Revision  : version: 1.0
**  Projekt-Revision: 1.0
**--------------------------------------------------------------------**
nokeywords
**--------------------------------------------------------------------*)
unit Main;
(*--------------------------------------------------------------------*)
(*		          													                            *)
(*	 Small Demo Application to demonstrate TMMPlot lite Component                *)
(*		          													                            *)
(*--------------------------------------------------------------------*)
interface

uses
  SysUtils, WinTypes, WinProcs, Messages, Classes, Graphics, Controls,
  Forms, Dialogs, StdCtrls, Buttons, ExtCtrls, Menus, Gauges, Printers,
  Settings, MMPlot_u, unit1, unit2, unit3;

type
  TMainForm = class(TForm)
    MainMenu: TMainMenu;
    FileOpenItem: TMenuItem;
    FilePrintItem: TMenuItem;
    FilePrintSetupItem: TMenuItem;
    FileExitItem: TMenuItem;
    PrintDialog: TPrintDialog;
    PrintSetupDialog: TPrinterSetupDialog;
    SpeedBar: TPanel;
    btnopen: TSpeedButton;
    btnhardcopy: TSpeedButton;
    btnprntsetup: TSpeedButton;
    SpeedButton5: TSpeedButton;
    btnPaint: TSpeedButton;
    PaintBox1: TPaintBox;
    Plotinfo: TSpeedButton;
    mInfo: TMenuItem;
    Plotinfo1: TMenuItem;
    mOptions: TMenuItem;
    Anzeige: TMenuItem;
    Toolb: TMenuItem;
    mView: TMenuItem;
    btnprint: TSpeedButton;
    MMPlot1: TMMPlot;
    moIsotropic: TMenuItem;
    moAnisotropic: TMenuItem;
    IsoAniso: TSpeedButton;
    btnsave: TSpeedButton;
    FileSaveItem: TMenuItem;
    moHardCopy: TMenuItem;
    moAbout: TMenuItem;
    OpenDialog: TOpenDialog;
    DragPanel: TPanel;
    Panpad: TPanel;
    btL: TSpeedButton;
    btU: TSpeedButton;
    btD: TSpeedButton;
    btR: TSpeedButton;
    btDL: TSpeedButton;
    btUL: TSpeedButton;
    btUR: TSpeedButton;
    btDR: TSpeedButton;
    btC: TSpeedButton;
    moSettings: TMenuItem;
    btnrot_0: TSpeedButton;
    btnrot_180: TSpeedButton;
    SaveDialog: TSaveDialog;
    SpeedButton1: TSpeedButton;
    SpeedButton2: TSpeedButton;
    SpeedButton3: TSpeedButton;
    procedure FileOpen(Sender: TObject);
    procedure FilePrint(Sender: TObject);
    procedure FilePrintSetup(Sender: TObject);
    procedure FileExit(Sender: TObject);
    procedure btnPaintClick(Sender: TObject);
    procedure PlotinfoClick(Sender: TObject);
    procedure Plotinfo1Click(Sender: TObject);
    procedure AnzeigeClick(Sender: TObject);
    procedure ToolbClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure Filesave(Sender: TObject);
    procedure Hardcopy(Sender: TObject);
    procedure moIsotropicClick(Sender: TObject);
    procedure IsoAnisoClick(Sender: TObject);
    procedure moAboutClick(Sender: TObject);
    procedure PaintBoxMouseDown(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure PaintBoxMouseUp(Sender: TObject; Button: TMouseButton;
      Shift: TShiftState; X, Y: Integer);
    procedure PaintBoxMouseMove(Sender: TObject; Shift: TShiftState; X,
      Y: Integer);
    procedure PanClick(Sender: TObject);
    procedure moSettingsClick(Sender: TObject);
    procedure rotclick(Sender: TObject);
    procedure SpeedButton1Click(Sender: TObject);
    procedure SpeedButton2Click(Sender: TObject);
    procedure SpeedButton3Click(Sender: TObject);
  private
    p1,p2: tpoint;
    r1,r2: trect;
    fcapture : boolean;
  public
    autostretch : boolean;
  end;
var
  MainForm: TMainForm;

implementation

{$R *.DFM}

procedure TMainForm.FileOpen(Sender: TObject);
var activate:boolean;
begin
  if OpenDialog.Execute then
  begin
    Activate := MMPlot1.active;
    MMPlot1.active := false;
    MMPlot1.Close;
    MMPlot1.Filename := OpenDialog.Filename;
    If Activate then MMPlot1.active := true;
  end;
end;

procedure TMainForm.FilePrint(Sender: TObject);
var x,y: longint;
    n  : word;
    p  : pPrintSpec;
begin
  PrintDialog.Options := PrintDialog.Options + [poPagenums];
  PrintDialog.PrintRange := prAllPages;
  if MMPlot1.Size(x,y,n) then n := 1;
  PrintDialog.MinPage := 1;
  PrintDialog.FromPage := 1;
  PrintDialog.MaxPage := n;
  PrintDialog.ToPage := n;
  if PrintDialog.Execute then
  begin
    btnPaint.down := false;
    btnPaint.enabled := false;
    if assigned(MMPlot1) then
      MMPlot1.Close;
    If PrintDialog.PrintRange = prAllPages then
    Begin
      PrintDialog.FromPage := 1;  { ~ 1 }
      PrintDialog.ToPage := 9999;    { ~ n }
    End;
    P := New(pPrintspec);
    With p^ do
    begin
      Dest := Printer;
      Mapmode := 2;
      FromPage := PrintDialog.FromPage;
      ToPage := PrintDialog.ToPage;
      Penfactor := MMPlot1.Penfactor;
      Scale := MMPlot1.Scale;
      Ditherofs := MMPlot1.Ditherofs;
      BlackPrint := MMPlot1.BlackPrint;
      ZoomPen := MMPlot1.ZoomPen;
      Options := MMPlot1.Options;
    end;
    OutPlot( Opendialog.Filename, P);
    dispose (p);
    btnPaint.enabled := true;
  end;
end;

procedure TMainForm.FilePrintSetup(Sender: TObject);
begin
  PrintSetupDialog.Execute;
end;

procedure TMainForm.FileExit(Sender: TObject);
begin
  Close;
end;

procedure TMainForm.btnPaintClick(Sender: TObject);
begin
  Anzeige.Checked := btnPaint.down;
  MMPlot1.active := btnPaint.down;
  PaintBox1.Refresh;
end;

procedure TMainForm.PlotinfoClick(Sender: TObject);
var s:string;
    x,y:longint;
    n : word;
begin
  if MMPlot1.Size(x,y,n) then Exit;
  s := OpenDialog.Filename + #13#10 +
       'Width: ' + inttostr(x) +
       'mm   Height:' + inttostr(y) + 'mm' + #13#10 +
       'Printpages: ' + inttostr(n);
  MessageDlg(s, mtInformation, [mbOk], 0);
end;

procedure TMainForm.Plotinfo1Click(Sender: TObject);
begin
  PlotInfoClick(Sender);
end;

procedure TMainForm.AnzeigeClick(Sender: TObject);
begin
  btnPaint.down := not btnPaint.down;
  btnPaintClick(Sender);
end;

procedure TMainForm.ToolbClick(Sender: TObject);
begin
  Speedbar.visible := not Toolb.Checked;
  Toolb.Checked := not Toolb.Checked;
end;

procedure TMainForm.FormCreate(Sender: TObject);
begin
  fCapture := FALSE;
  IsoAnIso.down := MMPlot1.MapMode = mmAnisotropic;
end;

procedure TMainForm.Filesave(Sender: TObject);
var activate:boolean;
begin
  if SaveDialog.Execute then
  begin
    Activate := MMPlot1.active;
    MMPlot1.active := false;
    If MMPlot1.SaveFileAs(SaveDialog.Filename) then
       MessageDlg( 'Store failed !'+#13+
                   'Possibly wrong Extension'
                  , mtWarning,[mbOk], 0);
    If Activate then MMPlot1.active := true;
  end;
end;

procedure TMainForm.Hardcopy(Sender: TObject);
begin
  MMPlot1.Hardcopy;
end;

procedure TMainForm.moIsotropicClick(Sender: TObject);
begin
  IsoAnIso.down := Sender = moAnIsotropic;
  IsoAnisoClick(Sender);
end;

procedure TMainForm.IsoAnisoClick(Sender: TObject);
begin
  If IsoAnIso.down then
    MMPlot1.MapMode := mmAnisotropic
  Else
    MMPlot1.MapMode := mmIsotropic;
  moIsotropic.Checked := not IsoAnIso.down;
  moAnIsotropic.Checked := IsoAnIso.down;
  MMPlot1.ZoomAll;
  PaintBox1.Refresh;
end;

procedure TMainForm.moAboutClick(Sender: TObject);
begin
  MessageDlg( 'Demo for MMPLOT-HPGL/2-Component'+#13+
              'Component: Rev.'+MMPlot1.Version+#13+
              'MMPlot.DLL:Rev.'+MMPLOT_U.GetDLLVersion+#13+
              'MAMAVISION Software Consult'+#13+
              'CIS 100335,430'
              , mtInformation,[mbOk], 0);
end;

procedure TMainForm.PaintBoxMouseDown(Sender: TObject;
  Button: TMouseButton; Shift: TShiftState; X, Y: Integer);
begin
  if button = mbLeft then
  begin
    r1.top :=y;
    r1.left:=x;
    r1.bottom := y;
    r1.right := x;
    r2 := r1;
    mainform.canvas.drawfocusrect(r2);
    fCapture := TRUE;
  end;
end;

procedure TMainForm.PaintBoxMouseUp(Sender: TObject; Button: TMouseButton;
  Shift: TShiftState; X, Y: Integer);
begin
  if button = mbLeft then
  begin
    if (not fCapture) then exit;
    fCapture := FALSE;
    mainform.canvas.drawfocusrect(r2);
    if (r2.top = r2.bottom) or (r2.left = r2.right) then exit;
    MMPlot1.SetZoom(r2);
    TPaintBox(Sender).Refresh;
  end else
  begin
    fCapture := FALSE;
    MMPlot1.ZoomAll;
    TPaintBox(Sender).Refresh;
  end;
end;

procedure TMainForm.PaintBoxMouseMove(Sender: TObject; Shift: TShiftState;
  X, Y: Integer);
begin
  if (not fCapture) then exit;
  mainform.canvas.drawfocusrect(r2);
  r1.bottom := y;
  r1.right := x;
  r2 := r1;
  (* sicherstellen, dass links < rechts ist *)
  if(r1.left > r1.right) then
  begin
    r2.left := r1.right;
    r2.right := r1.left;;
  end;
  if(r1.top > r1.bottom) then
  begin
    r2.top := r1.bottom;
    r2.bottom := r1.top;
  end;
  mainform.canvas.drawfocusrect(r2);
end;

procedure TMainForm.PanClick(Sender: TObject);
  var r:trect;
begin
  fillchar(r,sizeof(trect),#0);
  if sender = btL then r.left := 50
  else if sender = btU then r.top := 50
  else if sender = btR then r.right := 50
  else if sender = btD then r.bottom := 50
  else if sender = btUL then
  begin
   r.left := 40;
   r.top  := 40;
  end else if sender = btUR then
  begin
   r.right := 40;
   r.top := 40;
  end else if sender = btDL then
  begin
   r.left := 40;
   r.bottom := 40;
  end else if sender = btDR then
  begin
   r.right := 40;
   r.bottom := 40;
  end else if sender = btC then
  begin
    MMPlot1.ZoomAll;
    MMPlot1.Display.refresh;
    Exit;
  end else exit;
  MMPlot1.Pan(r);
  MMPlot1.Display.refresh;
end;

procedure TMainForm.moSettingsClick(Sender: TObject);
begin
  If SettingsDlg.ShowModal = mrOK then
    Paintbox1.refresh;
end;

procedure TMainForm.rotclick(Sender: TObject);
var r:real;
    s:string;
    ierr:integer;
begin
  if Sender = btnrot_0 then
  begin
    r := 0.0;
    btnrot_180.visible := true;
  end else if Sender = btnrot_180 then
  begin
    r := 180.0;
    btnrot_0.visible := true;
  end;
  tspeedbutton(sender).visible := false;
  If MMPlot1.Angle <> r then
  begin
    MMPlot1.Angle := r;
    Paintbox1.refresh;
  end;
end;

procedure TMainForm.SpeedButton1Click(Sender: TObject);
begin
  Form1.Showmodal;
end;

procedure TMainForm.SpeedButton2Click(Sender: TObject);
begin
  Form2.Show;
end;

procedure TMainForm.SpeedButton3Click(Sender: TObject);
begin
  Form3.Show;
end;

end.
